﻿# ================================================================================================================
# Paket: Citrix Secure Access Client
# Beschreibung: <Kurzbeschreibung des Pakets>
# Autor: Hutzelma
# Erstelldatum: 02.12.2025
# Revision: 1
# Letzte Änderung: 02.12.2025
# Historie: <Kurze Beschreibung der Änderungen>
# Abhängigkeiten: <Abhängige Pakete oder Systemkomponten>
# Besonderheiten: <Links, Blogs, KB-Artikel, etc.>
# ================================================================================================================
# 
# ===== Installationsvariablen
Set-PdVar -Name _MsiName -Value '.\Files\agee64.msi'
Set-PdVar -Name _MSI_Parameters -Value 'ALLUSERS=1'
Set-PdVar -Name _ProcessNames -Value "nglauncher.exe,nsClientCollect.exe,nswcc.exe,nsepa.exe,nsauto.exe,nsload.exe,aoservice.exe,nsverctl.exe,msiexec.exe,CiscoCollabHost.exe,webex_vdi.exe,webexvdi.exe,msiexec.exe,CDViewer.exe"
Set-PdVar -Name _ProcessNames_ADT_Dialog -Value 'CDViewer=Virtueller Arbeitsplatz'
Set-PdVar -Name _SAC_Version -Value '25.9.1.5'
# ===== Allgemeine Variablen
Set-PdVar -Name _ReturnCode -Value 'n/a'
#       
# ===== Abfrage ob installierte Version kleiner als Paketversion
if ((Get-FileVersion -Path "${env:ProgramFiles}\Citrix\Secure Access Client\nswcc.exe") -ge $_SAC_Version)
{
    Exit-Package -Status Done -Message 'Gleiche oder neuere Version ist bereits installiert.' -ExitCode 0
}
# 
# ===== Installation
Show-ADTInstallationWelcome -CloseApps $_ProcessNames_ADT_Dialog -ForceCloseAppsCountdown 3600 -PromptToSave -BlockExecution -MinimizeWindows $true -TopMost $true -Context Computer
Show-ADTInstallationProgress -StatusMessage "Die Installation des Pakets ${CurrentPackage.Name} wird momentan ausgeführt. Bitte arbeiten Sie während dieses Vorgangs nicht an Ihrem Laptop. Falls ein Neustart erforderlich ist, werden Sie anschließend dazu aufgefordert, Ihr Gerät neu zu starten." -WindowLocation Default -TopMost $true -Context Computer
# 
# === Laufende Prozesse, die in der Prozesslistenvariable definiert sind, beenden
if ($_ProcessNames -ne '')
{
    foreach ($_Process in ($_ProcessNames -split ",")) {Stop-PdProcess -Name $_Process -NameOf File -Select AllMatches -SupportUninstall -Context Computer -ContinueOnError}
}
# 
Install-MsiProduct -Path $_MsiName -InstallationMode Install -Target AllUsers -Options "params:${_MSI_Parameters}" -LogLevel NORMAL -ResultVariable _ReturnCode -Context Computer
#
Write-RegistryValue -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\CAG' -ValueName Access -Value 517241 -ValueKind String -Action Set -Context Computer
Write-RegistryDWord -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName AlwaysOn -Value 1 -Action Set -Context Computer
Write-RegistryValue -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName AlwaysOnURL -Value 'https://ina.kvbawue.de/' -ValueKind String -Action Set -Context Computer
Write-RegistryDWord -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName ClientControl -Value 1 -Action Set -Context Computer
Write-RegistryDWord -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName EnableVA -Value 1 -Action Set -Context Computer
Write-RegistryDWord -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName locationDetection -Value 1 -Action Set -Context Computer
Write-RegistryDWord -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName LoginType -Value 1 -Action Set -Context Computer
Write-RegistryValue -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName suffixList -Value 'kvbw.local;' -ValueKind String -Action Set -Context Computer
Write-RegistryDWord -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName DisableIconHide -Value 1 -Action Set -Context Computer
Write-RegistryValue -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName UserCertCAList -Value 'KVBAWUE Internal User CA, KVBW Internal User CA v1' -ValueKind String -Action Set -Context Computer
Write-RegistryDWord -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName EnableEdgeWebView -Value 0 -Action Set -Context Computer
Write-RegistryDWord -KeyPath 'HKEY_LOCAL_MACHINE\SOFTWARE\Citrix\Secure Access Client' -ValueName EnableWFP -Value 1 -Action Set -Context Computer
# 
if ($_ReturnCode -ne 'n/a')
{
    if ($_ReturnCode -eq 0)
    {
        Exit-Package -Status Done -ExitCode 0 -Message 'Installation erfolgreich.'
    }
    elseif ($_ReturnCode -eq 1707)
    {
		Exit-Package -Status Done -ExitCode 1707 -Message 'Installation erfolgreich.'
    }
    elseif ($_ReturnCode -eq 1641)
    {
		Exit-Package -Status Done -ExitCode 1641 -Message 'Das Setup hat den Rückgabewert 1641 zurückgegeben. Installation erfolgreich ein Neustart wurde eingeleitet.'
    }
    elseif ($_ReturnCode -eq 3010)
    {
        Exit-Package -Status Done -ExitCode 3010 -Message 'Das Setup hat den Rückgabewert 3010 zurückgegeben. Installation erfolgreich ein Neustart ist erforderlich.'
    }
    elseif ($_ReturnCode -eq 1602)
    {
        Exit-Package -Status Failed -ExitCode 1602 -Message 'Das Setup hat den Rückgabewert 1602 zurückgegeben. Abbruch durch Benutzer.'
    }
    elseif ($_ReturnCode -eq 1618)
    {
        Exit-Package -Status Undone -ExitCode 1618 -Message 'Das Setup hat den Rückgabewert 1618 zurückgegeben. Eine andere MSI-Installation wird aktuell ausgeführt.'
    }
    elseif ($_ReturnCode -eq 1638)
    {
        Exit-Package -Status Failed -ExitCode 1638 -Message 'Das Setup hat den Rückgabewert 1638 zurückgegeben. Eine andere Version dieses Produkts ist bereits installiert.'
    }
    else
    {
        Exit-Package -Status Failed -ExitCode $_ReturnCode -Message "Abbruch. Die Ausführung wurde mit dem Rückgabewert ${_ReturnCode} beendet."
    }
}
# Kein Rückgabewert verfügbar - Installation wurde vermutlich nicht abgeschlossen
Exit-Package -Status Failed -Message 'Status unbekannt'
# 
# ===== Deinstallation
# Die Befehle zwischen der Sprungmarke $BeginUninstallScript und dem Ende des Skripts werden (ausschließlich) bei der Deinstallation des Pakets ausgeführt.
# Fügen Sie hier Befehle hinzu, um Installationsbefehle rückgängig zu machen, für die eine automatische Deinstallation nicht möglich ist.
Set-Label -Name "`$BeginUninstallScript"
if ($_ReturnCode -ne 'n/a')
{
    if ($_ReturnCode -eq 0)
    {
        Exit-Package -Status Done -ExitCode 0 -Message 'Deinstallation erfolgreich.'
    }
    elseif ($_ReturnCode -eq 1707)
    {
		Exit-Package -Status Done -ExitCode 1707 -Message 'Deinstallation erfolgreich.'
    }
    elseif ($_ReturnCode -eq 1641)
    {
		Exit-Package -Status Done -ExitCode 1641 -Message 'Das Setup hat den Rückgabewert 1641 zurückgegeben. Deinstallation erfolgreich ein Neustart wurde eingeleitet.'
    }
    elseif ($_ReturnCode -eq 3010)
    {
        Exit-Package -Status Done -ExitCode 3010 -Message 'Das Setup hat den Rückgabewert 3010 zurückgegeben. Deinstallation erfolgreich ein Neustart ist erforderlich.'
    }
    elseif ($_ReturnCode -eq 1602)
    {
        Exit-Package -Status Failed -ExitCode 1602 -Message 'Das Setup hat den Rückgabewert 1602 zurückgegeben. Abbruch durch Benutzer.'
    }
    elseif ($_ReturnCode -eq 1618)
    {
        Exit-Package -Status Undone -ExitCode 1618 -Message 'Das Setup hat den Rückgabewert 1618 zurückgegeben. Eine andere MSI-Installation wird aktuell ausgeführt.'
    }
    else
    {
        Exit-Package -Status Failed -ExitCode $_ReturnCode -Message "Abbruch. Die Ausführung wurde mit dem Rückgabewert ${_ReturnCode} beendet."
    }
}
# Kein Rückgabewert verfügbar - Installation wurde vermutlich nicht abgeschlossen
Exit-Package -Status Failed -Message 'Status unbekannt'
